/*
 * Decompiled with CFR 0.152.
 */
package i18nupdatemod;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import i18nupdatemod.core.GameConfig;
import i18nupdatemod.core.I18nConfig;
import i18nupdatemod.core.ResourcePack;
import i18nupdatemod.core.ResourcePackConverter;
import i18nupdatemod.entity.GameAssetDetail;
import i18nupdatemod.util.FileUtil;
import i18nupdatemod.util.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class I18nUpdateMod {
    public static final String MOD_ID = "i18nupdatemod";
    public static String MOD_VERSION;
    public static final Gson GSON;

    public static void init(Path minecraftPath, String minecraftVersion, String loader) {
        try (InputStream is = I18nUpdateMod.class.getResourceAsStream("/i18nMetaData.json");){
            MOD_VERSION = ((JsonObject)GSON.fromJson((Reader)new InputStreamReader(is), JsonObject.class)).get("version").getAsString();
        }
        catch (Exception e) {
            Log.warning("Error getting version: " + e);
        }
        Log.info(String.format("I18nUpdate Mod %s is loaded in %s with %s", MOD_VERSION, minecraftVersion, loader));
        Log.debug(String.format("Minecraft path: %s", minecraftPath));
        String localStorage = I18nUpdateMod.getLocalStoragePos(minecraftPath);
        Log.debug(String.format("Local Storage Pos: %s", localStorage));
        try {
            Class.forName("com.netease.mc.mod.network.common.Library");
            Log.warning("I18nUpdateMod will get resource pack from Internet, whose content is uncontrolled.");
            Log.warning("This behavior contraries to Netease Minecraft developer content review rule: forbidden the content in game not match the content for reviewing.");
            Log.warning("To follow this rule, I18nUpdateMod won't download any thing.");
            Log.warning("I18nUpdateMod\u4f1a\u4ece\u4e92\u8054\u7f51\u83b7\u53d6\u5185\u5bb9\u4e0d\u53ef\u63a7\u7684\u8d44\u6e90\u5305\u3002");
            Log.warning("\u8fd9\u4e00\u884c\u4e3a\u8fdd\u80cc\u4e86\u7f51\u6613\u6211\u7684\u4e16\u754c\u300c\u5f00\u53d1\u8005\u5185\u5bb9\u5ba1\u6838\u5236\u5ea6\u300d\uff1a\u7981\u6b62\u4e0a\u4f20\u4e0e\u63d0\u5ba1\u5185\u5bb9\u4e0d\u4e00\u81f4\u7684\u6e38\u620f\u5185\u5bb9\u3002");
            Log.warning("\u4e3a\u4e86\u9075\u5faa\u8fd9\u4e00\u5236\u5ea6\uff0cI18nUpdateMod\u4e0d\u4f1a\u4e0b\u8f7d\u4efb\u4f55\u5185\u5bb9\u3002");
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            FileUtil.setResourcePackDirPath(minecraftPath.resolve("resourcepacks"));
            int minecraftMajorVersion = Integer.parseInt(minecraftVersion.split("\\.")[1]);
            try {
                GameAssetDetail assets = I18nConfig.getAssetDetail(minecraftVersion, loader);
                ArrayList<ResourcePack> languagePacks = new ArrayList<ResourcePack>();
                boolean convertNotNeed = assets.downloads.size() == 1 && assets.downloads.get((int)0).targetVersion.equals(minecraftVersion);
                String applyFileName = assets.downloads.get((int)0).fileName;
                for (GameAssetDetail.AssetDownloadDetail it : assets.downloads) {
                    FileUtil.setTemporaryDirPath(Paths.get(localStorage, ".i18nupdatemod", it.targetVersion));
                    ResourcePack languagePack = new ResourcePack(it.fileName, convertNotNeed);
                    languagePack.checkUpdate(it.fileUrl, it.md5Url);
                    languagePacks.add(languagePack);
                }
                if (!convertNotNeed) {
                    FileUtil.setTemporaryDirPath(Paths.get(localStorage, ".i18nupdatemod", minecraftVersion));
                    applyFileName = assets.covertFileName;
                    ResourcePackConverter converter = new ResourcePackConverter(languagePacks, applyFileName);
                    converter.convert(assets.covertPackFormat, I18nUpdateMod.getResourcePackDescription(assets.downloads));
                }
                GameConfig config = new GameConfig(minecraftPath.resolve("options.txt"));
                config.addResourcePack("Minecraft-Mod-Language-Modpack", (minecraftMajorVersion <= 12 ? "" : "file/") + applyFileName);
                config.writeToFile();
            }
            catch (Exception e) {
                Log.warning(String.format("Failed to update resource pack: %s", e));
            }
            return;
        }
    }

    private static String getResourcePackDescription(List<GameAssetDetail.AssetDownloadDetail> downloads) {
        return downloads.size() > 1 ? String.format("\u8be5\u5305\u7531%s\u7248\u672c\u5408\u5e76\n\u4f5c\u8005\uff1aCFPA\u56e2\u961f\u53ca\u6c49\u5316\u9879\u76ee\u8d21\u732e\u8005", downloads.stream().map(it -> it.targetVersion).collect(Collectors.joining("\u548c"))) : String.format("\u8be5\u5305\u5bf9\u5e94\u7684\u5b98\u65b9\u652f\u6301\u7248\u672c\u4e3a%s\n\u4f5c\u8005\uff1aCFPA\u56e2\u961f\u53ca\u6c49\u5316\u9879\u76ee\u8d21\u732e\u8005", downloads.get((int)0).targetVersion);
    }

    public static String getLocalStoragePos(Path minecraftPath) {
        String userHome = System.getProperty("user.home");
        Path oldPath = Paths.get(userHome, ".i18nupdatemod");
        if (Files.exists(oldPath, new LinkOption[0])) {
            return userHome;
        }
        String localAppData = System.getenv("LocalAppData");
        String xdgDataHome = System.getenv("XDG_DATA_HOME");
        if (localAppData != null) {
            return localAppData;
        }
        if (xdgDataHome != null) {
            return xdgDataHome;
        }
        return minecraftPath.toString();
    }

    static {
        GSON = new Gson();
    }
}

