/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import fi.dy.masa.servux.Reference;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderBase;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.ServerPlayHandler;
import fi.dy.masa.servux.network.packet.ServuxLitematicaHandler;
import fi.dy.masa.servux.network.packet.ServuxLitematicaPacket;
import fi.dy.masa.servux.schematic.placement.SchematicPlacement;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.settings.ServuxBoolSetting;
import fi.dy.masa.servux.settings.ServuxIntSetting;
import fi.dy.masa.servux.util.EntityUtils;
import fi.dy.masa.servux.util.NBTUtils;
import fi.dy.masa.servux.util.PositionUtils;
import fi.dy.masa.servux.util.ReplaceBehavior;
import fi.dy.masa.servux.util.StringUtils;
import java.util.List;
import java.util.Set;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;

public class LitematicsDataProvider
extends DataProviderBase {
    public static final LitematicsDataProvider INSTANCE = new LitematicsDataProvider();
    protected static final ServuxLitematicaHandler<ServuxLitematicaPacket.Payload> HANDLER = ServuxLitematicaHandler.getInstance();
    protected final class_2487 metadata = new class_2487();
    protected ServuxIntSetting permissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level", 0, 4, 0);
    protected ServuxIntSetting pastePermissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level_paste", 0, 4, 0);
    public ServuxBoolSetting fixRaiLRotations = new ServuxBoolSetting(this, "fix_rail_rotations", true);
    private final List<IServuxSetting<?>> settings = List.of(this.permissionLevel, this.pastePermissionLevel, this.fixRaiLRotations);

    protected LitematicsDataProvider() {
        super("litematic_data", ServuxLitematicaHandler.CHANNEL_ID, 1, 0, "servux.provider.litematic_data", "Litematics Data provider.");
        this.metadata.method_10582("name", this.getName());
        this.metadata.method_10582("id", this.getNetworkChannel().toString());
        this.metadata.method_10569("version", this.getProtocolVersion());
        this.metadata.method_10582("servux", Reference.MOD_STRING);
    }

    @Override
    public List<IServuxSetting<?>> getSettings() {
        return this.settings;
    }

    @Override
    public void registerHandler() {
        ServerPlayHandler.getInstance().registerServerPlayHandler(HANDLER);
        if (!this.isRegistered()) {
            HANDLER.registerPlayPayload(ServuxLitematicaPacket.Payload.ID, ServuxLitematicaPacket.Payload.CODEC, 3);
            this.setRegistered(true);
        }
        HANDLER.registerPlayReceiver(ServuxLitematicaPacket.Payload.ID, (ServerPlayNetworking.PlayPayloadHandler<ServuxLitematicaPacket.Payload>)((ServerPlayNetworking.PlayPayloadHandler)HANDLER::receivePlayPayload));
    }

    @Override
    public void unregisterHandler() {
        HANDLER.unregisterPlayReceiver();
        ServerPlayHandler.getInstance().unregisterServerPlayHandler(HANDLER);
    }

    @Override
    public IPluginServerPlayHandler<?> getPacketHandler() {
        return HANDLER;
    }

    public void sendMetadata(class_3222 player) {
        if (!this.hasPermission(player)) {
            Servux.debugLog("litematic_data: Denying access for player {}, Insufficient Permissions", player.method_5477().method_54160());
            return;
        }
        Servux.debugLog("litematic_data: sendMetadata to player {}", player.method_5477().method_54160());
        if (player.field_13987 != null) {
            HANDLER.sendPlayPayload(player.field_13987, new ServuxLitematicaPacket.Payload(ServuxLitematicaPacket.MetadataResponse(this.metadata)));
        } else {
            HANDLER.sendPlayPayload(player, new ServuxLitematicaPacket.Payload(ServuxLitematicaPacket.MetadataResponse(this.metadata)));
        }
    }

    public void onPacketFailure(class_3222 player) {
    }

    public void onBlockEntityRequest(class_3222 player, class_2338 pos) {
        if (!this.hasPermission(player)) {
            return;
        }
        class_2586 be = player.method_5770().method_8321(pos);
        class_2487 nbt = be != null ? be.method_38242((class_7225.class_7874)player.method_56673()) : new class_2487();
        HANDLER.encodeServerData(player, ServuxLitematicaPacket.SimpleBlockResponse(pos, nbt));
    }

    public void onEntityRequest(class_3222 player, int entityId) {
        if (!this.hasPermission(player)) {
            return;
        }
        class_1297 entity = player.method_37908().method_8469(entityId);
        class_2487 nbt = new class_2487();
        if (entity != null && entity.method_5786(nbt)) {
            HANDLER.encodeServerData(player, ServuxLitematicaPacket.SimpleEntityResponse(entityId, nbt));
        }
    }

    public void onBulkEntityRequest(class_3222 player, class_1923 chunkPos, class_2487 req) {
        class_2791 chunk;
        if (!this.hasPermission(player)) {
            return;
        }
        if (req == null || req.method_33133()) {
            return;
        }
        class_3218 world = player.method_51469();
        class_2791 class_27912 = chunk = world != null ? world.method_8402(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false) : null;
        if (chunk == null) {
            return;
        }
        if (req.method_10545("Task") && req.method_10558("Task").equals("BulkEntityRequest") || !req.method_10545("Task")) {
            long timeStart = System.currentTimeMillis();
            class_2499 tileList = new class_2499();
            class_2499 entityList = new class_2499();
            int minY = req.method_10550("minY");
            int maxY = req.method_10550("maxY");
            class_2338 pos1 = new class_2338(chunkPos.method_8326(), minY, chunkPos.method_8328());
            class_2338 pos2 = new class_2338(chunkPos.method_8327(), maxY, chunkPos.method_8329());
            class_238 bb = PositionUtils.createEnclosingAABB(pos1, pos2);
            Set teSet = chunk.method_12021();
            List entities = world.method_8333(null, bb, EntityUtils.NOT_PLAYER);
            for (class_2338 tePos : teSet) {
                if (tePos.method_10263() < chunkPos.method_8326() || tePos.method_10263() > chunkPos.method_8327() || tePos.method_10260() < chunkPos.method_8328() || tePos.method_10260() > chunkPos.method_8329() || tePos.method_10264() < minY || tePos.method_10264() > maxY) continue;
                class_2586 be = world.method_8321(tePos);
                class_2487 beTag = be != null ? be.method_38242((class_7225.class_7874)player.method_56673()) : new class_2487();
                tileList.add((Object)beTag);
            }
            for (class_1297 entity : entities) {
                class_2487 entTag;
                if (!entity.method_5662(entTag = new class_2487())) continue;
                class_243 posVec = new class_243(entity.method_23317() - (double)pos1.method_10263(), entity.method_23318() - (double)pos1.method_10264(), entity.method_23321() - (double)pos1.method_10260());
                NBTUtils.writeEntityPositionToTag(posVec, entTag);
                entTag.method_10569("entityId", entity.method_5628());
                entityList.add((Object)entTag);
            }
            class_2487 output = new class_2487();
            output.method_10582("Task", "BulkEntityReply");
            output.method_10566("TileEntities", (class_2520)tileList);
            output.method_10566("Entities", (class_2520)entityList);
            output.method_10569("chunkX", chunkPos.field_9181);
            output.method_10569("chunkZ", chunkPos.field_9180);
            long timeElapsed = System.currentTimeMillis() - timeStart;
            HANDLER.encodeServerData(player, ServuxLitematicaPacket.ResponseS2CStart(output));
        }
    }

    public void handleClientPasteRequest(class_3222 player, int transactionId, class_2487 tags) {
        if (!this.hasPermission(player) || !this.hasPermissionsForPaste(player)) {
            Servux.debugLog("litematic_data: Denying Litematic Paste for player {}, Insufficient Permissions.", player.method_5477().method_54160());
            player.method_43496((class_2561)StringUtils.translate("servux.litematics.error.insufficent_for_paste", new Object[0]));
            return;
        }
        if (!player.method_7337()) {
            Servux.debugLog("litematic_data: Denying Litematic Paste for player {}, Player is not in Creative Mode.", player.method_5477().method_54160());
            player.method_43496((class_2561)StringUtils.translate("servux.litematics.error.creative_required", new Object[0]));
            return;
        }
        if (tags.method_10558("Task").equals("LitematicaPaste")) {
            long timeStart = System.currentTimeMillis();
            SchematicPlacement placement = SchematicPlacement.createFromNbt(tags);
            ReplaceBehavior replaceMode = ReplaceBehavior.fromStringStatic(tags.method_10558("ReplaceMode"));
            placement.pasteTo(player.method_51469(), replaceMode);
            long timeElapsed = System.currentTimeMillis() - timeStart;
            player.method_7353((class_2561)StringUtils.translate("servux.litematics.success.pasted", placement.getName(), player.method_51469().method_27983().method_29177().toString(), timeElapsed), false);
        }
    }

    @Override
    public boolean hasPermission(class_3222 player) {
        return Permissions.check((class_1297)player, (String)this.permNode, (int)((Integer)this.permissionLevel.getValue()));
    }

    @Override
    public void onTickEndPre() {
    }

    @Override
    public void onTickEndPost() {
    }

    public boolean hasPermissionsForPaste(class_3222 player) {
        return this.hasPermission(player) && Permissions.check((class_1297)player, (String)(this.permNode + ".paste"), (int)((Integer)this.pastePermissionLevel.getValue()));
    }
}

