/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.network;

import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.network.IServerPayloadData;
import fi.dy.masa.servux.network.ServuxBuf;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public interface IPluginServerPlayHandler<T extends class_8710>
extends ServerPlayNetworking.PlayPayloadHandler<T> {
    public static final int FROM_SERVER = 1;
    public static final int TO_SERVER = 2;
    public static final int BOTH_SERVER = 3;
    public static final int TO_CLIENT = 4;
    public static final int FROM_CLIENT = 5;
    public static final int BOTH_CLIENT = 6;

    public class_2960 getPayloadChannel();

    public boolean isPlayRegistered(class_2960 var1);

    public void setPlayRegistered(class_2960 var1);

    public void reset(class_2960 var1);

    default public void registerPlayPayload(@Nonnull class_8710.class_9154<T> id, @Nonnull class_9139<? super class_9129, T> codec, int direction) {
        if (!this.isPlayRegistered(this.getPayloadChannel())) {
            try {
                switch (direction) {
                    case 2: 
                    case 5: {
                        PayloadTypeRegistry.playC2S().register(id, codec);
                        break;
                    }
                    case 1: 
                    case 4: {
                        PayloadTypeRegistry.playS2C().register(id, codec);
                        break;
                    }
                    default: {
                        PayloadTypeRegistry.playC2S().register(id, codec);
                        PayloadTypeRegistry.playS2C().register(id, codec);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                Servux.logger.error("registerPlayPayload: channel ID [{}] is is already registered", (Object)this.getPayloadChannel());
            }
            this.setPlayRegistered(this.getPayloadChannel());
            return;
        }
        Servux.logger.error("registerPlayPayload: channel ID [{}] is invalid, or it is already registered", (Object)this.getPayloadChannel());
    }

    default public boolean registerPlayReceiver(@Nonnull class_8710.class_9154<T> id, @Nullable ServerPlayNetworking.PlayPayloadHandler<T> receiver) {
        if (this.isPlayRegistered(this.getPayloadChannel())) {
            try {
                return ServerPlayNetworking.registerGlobalReceiver(id, (ServerPlayNetworking.PlayPayloadHandler)Objects.requireNonNullElse(receiver, this::receivePlayPayload));
            }
            catch (IllegalArgumentException e) {
                Servux.logger.error("registerPlayReceiver: Channel ID [{}] payload has not been registered", (Object)this.getPayloadChannel());
            }
        }
        Servux.logger.error("registerPlayReceiver: Channel ID [{}] is invalid, or not registered", (Object)this.getPayloadChannel());
        return false;
    }

    default public void unregisterPlayReceiver() {
        ServerPlayNetworking.unregisterGlobalReceiver((class_2960)this.getPayloadChannel());
    }

    public void receivePlayPayload(T var1, ServerPlayNetworking.Context var2);

    default public void receivePlayPayload(T payload, class_3244 handler, CallbackInfo ci) {
    }

    default public void decodeNbtCompound(class_2960 channel, class_3222 player, class_2487 data) {
    }

    default public void decodeByteBuf(class_2960 channel, class_3222 player, ServuxBuf data) {
    }

    default public <D> void decodeObject(class_2960 channel, class_3222 player, D data1) {
    }

    default public <P extends IServerPayloadData> void decodeServerData(class_2960 channel, class_3222 player, P data) {
    }

    default public void encodeNbtCompound(class_3222 player, class_2487 data) {
    }

    default public void encodeByteBuf(class_3222 player, ServuxBuf data) {
    }

    default public <D> void encodeObject(class_3222 player, D data1) {
    }

    default public <P extends IServerPayloadData> void encodeServerData(class_3222 player, P data) {
    }

    public void encodeWithSplitter(class_3222 var1, class_2540 var2, class_3244 var3);

    default public boolean sendPlayPayload(@Nonnull class_3222 player, @Nonnull T payload) {
        if (payload.method_56479().comp_2242().equals((Object)this.getPayloadChannel()) && this.isPlayRegistered(this.getPayloadChannel())) {
            if (ServerPlayNetworking.canSend((class_3222)player, (class_8710.class_9154)payload.method_56479())) {
                ServerPlayNetworking.send((class_3222)player, payload);
                return true;
            }
        } else {
            Servux.logger.warn("sendPlayPayload: [Fabric-API] error sending payload for channel: {}, check if channel is registered", (Object)payload.method_56479().comp_2242().toString());
        }
        return false;
    }

    default public boolean sendPlayPayload(@Nonnull class_3244 handler, @Nonnull T payload) {
        if (payload.method_56479().comp_2242().equals((Object)this.getPayloadChannel()) && this.isPlayRegistered(this.getPayloadChannel())) {
            class_2658 packet = new class_2658(payload);
            if (handler.method_52413((class_2596)packet)) {
                handler.method_14364((class_2596)packet);
                return true;
            }
        } else {
            Servux.logger.warn("sendPlayPayload: [NetworkHandler] error sending payload for channel: {}, check if channel is registered", (Object)payload.method_56479().comp_2242().toString());
        }
        return false;
    }
}

