/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.network.packet;

import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.network.IServerPayloadData;
import fi.dy.masa.servux.network.packet.ServuxEntitiesHandler;
import io.netty.buffer.Unpooled;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class ServuxTweaksPacket
implements IServerPayloadData {
    private Type packetType;
    private int transactionId;
    private int entityId;
    private class_2338 pos;
    private class_2487 nbt;
    private class_2540 buffer;
    private List<class_1923> requestingChunks;
    public static final int PROTOCOL_VERSION = 1;

    private ServuxTweaksPacket(Type type) {
        this.packetType = type;
        this.transactionId = -1;
        this.entityId = -1;
        this.pos = class_2338.field_10980;
        this.nbt = new class_2487();
        this.clearPacket();
    }

    public static ServuxTweaksPacket MetadataRequest(@Nullable class_2487 nbt) {
        ServuxTweaksPacket packet = new ServuxTweaksPacket(Type.PACKET_C2S_METADATA_REQUEST);
        if (nbt != null) {
            packet.nbt.method_10543(nbt);
        }
        return packet;
    }

    public static ServuxTweaksPacket MetadataResponse(@Nullable class_2487 nbt) {
        ServuxTweaksPacket packet = new ServuxTweaksPacket(Type.PACKET_S2C_METADATA);
        if (nbt != null) {
            packet.nbt.method_10543(nbt);
        }
        return packet;
    }

    public static ServuxTweaksPacket SimpleEntityResponse(int entityId, @Nullable class_2487 nbt) {
        ServuxTweaksPacket packet = new ServuxTweaksPacket(Type.PACKET_S2C_ENTITY_NBT_RESPONSE_SIMPLE);
        if (nbt != null) {
            packet.nbt.method_10543(nbt);
        }
        packet.entityId = entityId;
        return packet;
    }

    public static ServuxTweaksPacket SimpleBlockResponse(class_2338 pos, @Nullable class_2487 nbt) {
        ServuxTweaksPacket packet = new ServuxTweaksPacket(Type.PACKET_S2C_BLOCK_NBT_RESPONSE_SIMPLE);
        if (nbt != null) {
            packet.nbt.method_10543(nbt);
        }
        packet.pos = pos.method_10062();
        return packet;
    }

    public static ServuxTweaksPacket BlockEntityRequest(class_2338 pos) {
        ServuxTweaksPacket packet = new ServuxTweaksPacket(Type.PACKET_C2S_BLOCK_ENTITY_REQUEST);
        packet.pos = pos.method_10062();
        return packet;
    }

    public static ServuxTweaksPacket EntityRequest(int entityId) {
        ServuxTweaksPacket packet = new ServuxTweaksPacket(Type.PACKET_C2S_ENTITY_REQUEST);
        packet.entityId = entityId;
        return packet;
    }

    public static ServuxTweaksPacket ResponseS2CStart(@Nonnull class_2487 nbt) {
        ServuxTweaksPacket packet = new ServuxTweaksPacket(Type.PACKET_S2C_NBT_RESPONSE_START);
        packet.nbt.method_10543(nbt);
        return packet;
    }

    public static ServuxTweaksPacket ResponseS2CData(@Nonnull class_2540 buffer) {
        ServuxTweaksPacket packet = new ServuxTweaksPacket(Type.PACKET_S2C_NBT_RESPONSE_DATA);
        packet.buffer = buffer;
        packet.nbt = new class_2487();
        return packet;
    }

    public static ServuxTweaksPacket ResponseC2SStart(@Nonnull class_2487 nbt) {
        ServuxTweaksPacket packet = new ServuxTweaksPacket(Type.PACKET_C2S_NBT_RESPONSE_START);
        packet.nbt.method_10543(nbt);
        return packet;
    }

    public static ServuxTweaksPacket ResponseC2SData(@Nonnull class_2540 buffer) {
        ServuxTweaksPacket packet = new ServuxTweaksPacket(Type.PACKET_C2S_NBT_RESPONSE_DATA);
        packet.buffer = buffer;
        packet.nbt = new class_2487();
        return packet;
    }

    private void clearPacket() {
        if (this.buffer != null) {
            this.buffer.method_52931();
            this.buffer = new class_2540(Unpooled.buffer());
        }
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public int getPacketType() {
        return this.packetType.get();
    }

    @Override
    public int getTotalSize() {
        int total = 2;
        if (this.nbt != null && !this.nbt.method_33133()) {
            total += this.nbt.method_47988();
        }
        if (this.buffer != null) {
            total += this.buffer.readableBytes();
        }
        return total;
    }

    public Type getType() {
        return this.packetType;
    }

    public void setTransactionId(int id) {
        this.transactionId = id;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_2487 getCompound() {
        return this.nbt;
    }

    public class_2540 getBuffer() {
        return this.buffer;
    }

    public boolean hasBuffer() {
        return this.buffer != null && this.buffer.isReadable();
    }

    public boolean hasNbt() {
        return this.nbt != null && !this.nbt.method_33133();
    }

    @Override
    public boolean isEmpty() {
        return !this.hasBuffer() && !this.hasNbt();
    }

    @Override
    public void toPacket(class_2540 output) {
        output.method_10804(this.packetType.get());
        switch (this.packetType.ordinal()) {
            case 2: {
                try {
                    output.method_10804(this.transactionId);
                    output.method_10807(this.pos);
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxTweaksPacket#toPacket: error writing Block Entity Request to packet: [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            case 3: {
                try {
                    output.method_10804(this.transactionId);
                    output.method_10804(this.entityId);
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxTweaksPacket#toPacket: error writing Entity Request to packet: [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            case 4: {
                try {
                    output.method_10807(this.pos);
                    output.method_10794((class_2520)this.nbt);
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxTweaksPacket#toPacket: error writing Block Entity Response to packet: [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            case 5: {
                try {
                    output.method_10804(this.entityId);
                    output.method_10794((class_2520)this.nbt);
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxTweaksPacket#toPacket: error writing Entity Response to packet: [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            case 7: 
            case 9: {
                try {
                    output.method_52975(this.buffer.readBytes(this.buffer.readableBytes()));
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxTweaksPacket#toPacket: error writing buffer data to packet: [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            default: {
                Servux.logger.error("ServuxTweaksPacket#toPacket: Unknown packet type!");
            }
        }
    }

    @Nullable
    public static ServuxTweaksPacket fromPacket(class_2540 input) {
        int i = input.method_10816();
        Type type = ServuxTweaksPacket.getType(i);
        if (type == null) {
            Servux.logger.warn("ServuxTweaksPacket#fromPacket: invalid packet type received");
            return null;
        }
        switch (type.ordinal()) {
            case 2: {
                try {
                    input.method_10816();
                    return ServuxTweaksPacket.BlockEntityRequest(input.method_10811());
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxTweaksPacket#fromPacket: error reading Block Entity Request from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 3: {
                try {
                    input.method_10816();
                    return ServuxTweaksPacket.EntityRequest(input.method_10816());
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxTweaksPacket#fromPacket: error reading Entity Request from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 4: {
                try {
                    return ServuxTweaksPacket.SimpleBlockResponse(input.method_10811(), (class_2487)input.method_30616(class_2505.method_53898()));
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxTweaksPacket#fromPacket: error reading Block Entity Response from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 5: {
                try {
                    return ServuxTweaksPacket.SimpleEntityResponse(input.method_10816(), (class_2487)input.method_30616(class_2505.method_53898()));
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxTweaksPacket#fromPacket: error reading Entity Response from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 7: {
                try {
                    return ServuxTweaksPacket.ResponseS2CData(new class_2540(input.readBytes(input.readableBytes())));
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxTweaksPacket#fromPacket: error reading S2C Bulk Response Buffer from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 9: {
                try {
                    return ServuxTweaksPacket.ResponseC2SData(new class_2540(input.readBytes(input.readableBytes())));
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxTweaksPacket#fromPacket: error reading C2S Bulk Response Buffer from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 1: {
                try {
                    return ServuxTweaksPacket.MetadataRequest(input.method_10798());
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxTweaksPacket#fromPacket: error reading Metadata Request from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 0: {
                try {
                    return ServuxTweaksPacket.MetadataResponse(input.method_10798());
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxTweaksPacket#fromPacket: error reading Metadata Response from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            default: {
                Servux.logger.error("ServuxTweaksPacket#fromPacket: Unknown packet type!");
            }
        }
        return null;
    }

    @Override
    public void clear() {
        if (this.nbt != null && !this.nbt.method_33133()) {
            this.nbt = new class_2487();
        }
        this.clearPacket();
        this.transactionId = -1;
        this.entityId = -1;
        this.pos = class_2338.field_10980;
        this.packetType = null;
    }

    @Nullable
    public static Type getType(int input) {
        for (Type type : Type.values()) {
            if (type.get() != input) continue;
            return type;
        }
        return null;
    }

    public static enum Type {
        PACKET_S2C_METADATA(1),
        PACKET_C2S_METADATA_REQUEST(2),
        PACKET_C2S_BLOCK_ENTITY_REQUEST(3),
        PACKET_C2S_ENTITY_REQUEST(4),
        PACKET_S2C_BLOCK_NBT_RESPONSE_SIMPLE(5),
        PACKET_S2C_ENTITY_NBT_RESPONSE_SIMPLE(6),
        PACKET_S2C_NBT_RESPONSE_START(10),
        PACKET_S2C_NBT_RESPONSE_DATA(11),
        PACKET_C2S_NBT_RESPONSE_START(12),
        PACKET_C2S_NBT_RESPONSE_DATA(13);

        private final int type;

        private Type(int type) {
            this.type = type;
        }

        int get() {
            return this.type;
        }
    }

    public record Payload(ServuxTweaksPacket data) implements class_8710
    {
        public static final class_8710.class_9154<Payload> ID = new class_8710.class_9154(ServuxEntitiesHandler.CHANNEL_ID);
        public static final class_9139<class_2540, Payload> CODEC = class_8710.method_56484(Payload::write, Payload::new);

        public Payload(class_2540 input) {
            this(ServuxTweaksPacket.fromPacket(input));
        }

        private void write(class_2540 output) {
            this.data.toPacket(output);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }
}

