/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.schematic.placement;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.schematic.LitematicaSchematic;
import fi.dy.masa.servux.schematic.placement.SubRegionPlacement;
import fi.dy.masa.servux.schematic.selection.Box;
import fi.dy.masa.servux.util.IntBoundingBox;
import fi.dy.masa.servux.util.PositionUtils;
import fi.dy.masa.servux.util.ReplaceBehavior;
import fi.dy.masa.servux.util.SchematicPlacingUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_3218;

public class SchematicPlacement {
    private static final Set<Integer> USED_COLORS = new HashSet<Integer>();
    private final Map<String, SubRegionPlacement> relativeSubRegionPlacements = new HashMap<String, SubRegionPlacement>();
    private final int subRegionCount;
    private final LitematicaSchematic schematic;
    private class_2338 origin;
    private String name;
    private class_2470 rotation = class_2470.field_11467;
    private class_2415 mirror = class_2415.field_11302;
    private boolean ignoreEntities;
    private boolean regionPlacementsModified;
    private int coordinateLockMask;
    @Nullable
    private Box enclosingBox;

    private SchematicPlacement(LitematicaSchematic schematic, class_2338 origin, String name, boolean ignoreEntities) {
        this.schematic = schematic;
        this.origin = origin;
        this.name = name;
        this.subRegionCount = schematic.getSubRegionCount();
        this.ignoreEntities = ignoreEntities;
    }

    public static SchematicPlacement createFor(LitematicaSchematic schematic, class_2338 origin, String name, boolean ignoreEntities) {
        SchematicPlacement placement = new SchematicPlacement(schematic, origin, name, ignoreEntities);
        placement.resetAllSubRegionsToSchematicValues();
        return placement;
    }

    public static SchematicPlacement createFromNbt(class_2487 tags) {
        try {
            SchematicPlacement placement = new SchematicPlacement(new LitematicaSchematic(tags.method_10562("Schematics")), (class_2338)class_2512.method_10691((class_2487)tags, (String)"Origin").orElseThrow(), tags.method_10558("Name"), false);
            placement.mirror = class_2415.values()[tags.method_10550("Mirror")];
            placement.rotation = class_2470.values()[tags.method_10550("Rotation")];
            for (String name : tags.method_10562("SubRegions").method_10541()) {
                class_2487 compound = tags.method_10562("SubRegions").method_10562(name);
                SubRegionPlacement sub = new SubRegionPlacement((class_2338)class_2512.method_10691((class_2487)compound, (String)"Pos").orElseThrow(), compound.method_10558("Name"));
                sub.mirror = class_2415.values()[compound.method_10550("Mirror")];
                sub.rotation = class_2470.values()[compound.method_10550("Rotation")];
                sub.ignoreEntities = compound.method_10577("IgnoreEntities");
                sub.enabled = compound.method_10577("Enabled");
                placement.relativeSubRegionPlacements.put(name, sub);
            }
            return placement;
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean shouldRenderEnclosingBox() {
        return false;
    }

    public boolean isRegionPlacementModified() {
        return this.regionPlacementsModified;
    }

    public boolean ignoreEntities() {
        return this.ignoreEntities;
    }

    public String getName() {
        return this.name;
    }

    public LitematicaSchematic getSchematic() {
        return this.schematic;
    }

    @Nullable
    public Box getEclosingBox() {
        return this.enclosingBox;
    }

    public void setName(String name) {
        this.name = name;
    }

    public class_2338 getOrigin() {
        return this.origin;
    }

    public class_2470 getRotation() {
        return this.rotation;
    }

    public class_2415 getMirror() {
        return this.mirror;
    }

    public int getSubRegionCount() {
        return this.subRegionCount;
    }

    @Nullable
    public SubRegionPlacement getRelativeSubRegionPlacement(String areaName) {
        return this.relativeSubRegionPlacements.get(areaName);
    }

    public Collection<SubRegionPlacement> getAllSubRegionsPlacements() {
        return this.relativeSubRegionPlacements.values();
    }

    public ImmutableMap<String, SubRegionPlacement> getEnabledRelativeSubRegionPlacements() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, SubRegionPlacement> entry : this.relativeSubRegionPlacements.entrySet()) {
            SubRegionPlacement placement = entry.getValue();
            if (!placement.matchesRequirement(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED)) continue;
            builder.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        return builder.build();
    }

    private void updateEnclosingBox() {
        if (this.shouldRenderEnclosingBox()) {
            ImmutableMap<String, Box> boxes = this.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.ANY);
            class_2338 pos1 = null;
            class_2338 pos2 = null;
            for (Box box : boxes.values()) {
                class_2338 tmp = PositionUtils.getMinCorner(box.getPos1(), box.getPos2());
                if (pos1 == null) {
                    pos1 = tmp;
                } else if (tmp.method_10263() < pos1.method_10263() || tmp.method_10264() < pos1.method_10264() || tmp.method_10260() < pos1.method_10260()) {
                    pos1 = PositionUtils.getMinCorner(tmp, pos1);
                }
                tmp = PositionUtils.getMaxCorner(box.getPos1(), box.getPos2());
                if (pos2 == null) {
                    pos2 = tmp;
                    continue;
                }
                if (tmp.method_10263() <= pos2.method_10263() && tmp.method_10264() <= pos2.method_10264() && tmp.method_10260() <= pos2.method_10260()) continue;
                pos2 = PositionUtils.getMaxCorner(tmp, pos2);
            }
            if (pos1 != null && pos2 != null) {
                this.enclosingBox = new Box(pos1, pos2, "Enclosing Box");
            }
        }
    }

    public ImmutableMap<String, Box> getSubRegionBoxes(SubRegionPlacement.RequiredEnabled required) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map<String, class_2338> areaSizes = this.schematic.getAreaSizes();
        for (Map.Entry<String, SubRegionPlacement> entry : this.relativeSubRegionPlacements.entrySet()) {
            String name = entry.getKey();
            class_2338 areaSize = areaSizes.get(name);
            if (areaSize == null) {
                Servux.logger.warn("SchematicPlacement.getSubRegionBoxes(): Size for sub-region '{}' not found in the schematic '{}'", (Object)name, (Object)this.schematic.getMetadata().getName());
                continue;
            }
            SubRegionPlacement placement = entry.getValue();
            if (!placement.matchesRequirement(required)) continue;
            class_2338 boxOriginRelative = placement.getPos();
            class_2338 boxOriginAbsolute = PositionUtils.getTransformedBlockPos(boxOriginRelative, this.mirror, this.rotation).method_10081((class_2382)this.origin);
            class_2338 pos2 = PositionUtils.getRelativeEndPositionFromAreaSize((class_2382)areaSize);
            pos2 = PositionUtils.getTransformedBlockPos(pos2, this.mirror, this.rotation);
            pos2 = PositionUtils.getTransformedBlockPos(pos2, placement.getMirror(), placement.getRotation()).method_10081((class_2382)boxOriginAbsolute);
            builder.put((Object)name, (Object)new Box(boxOriginAbsolute, pos2, name));
        }
        return builder.build();
    }

    public ImmutableMap<String, Box> getSubRegionBoxFor(String regionName, SubRegionPlacement.RequiredEnabled required) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map<String, class_2338> areaSizes = this.schematic.getAreaSizes();
        SubRegionPlacement placement = this.relativeSubRegionPlacements.get(regionName);
        if (placement != null && placement.matchesRequirement(required)) {
            class_2338 areaSize = areaSizes.get(regionName);
            if (areaSize != null) {
                class_2338 boxOriginRelative = placement.getPos();
                class_2338 boxOriginAbsolute = PositionUtils.getTransformedBlockPos(boxOriginRelative, this.mirror, this.rotation).method_10081((class_2382)this.origin);
                class_2338 pos2 = PositionUtils.getRelativeEndPositionFromAreaSize((class_2382)areaSize);
                pos2 = PositionUtils.getTransformedBlockPos(pos2, this.mirror, this.rotation);
                pos2 = PositionUtils.getTransformedBlockPos(pos2, placement.getMirror(), placement.getRotation()).method_10081((class_2382)boxOriginAbsolute);
                builder.put((Object)regionName, (Object)new Box(boxOriginAbsolute, pos2, regionName));
            } else {
                Servux.logger.warn("SchematicPlacement.getSubRegionBoxFor(): Size for sub-region '{}' not found in the schematic '{}'", (Object)regionName, (Object)this.schematic.getMetadata().getName());
            }
        }
        return builder.build();
    }

    public Set<String> getRegionsTouchingChunk(int chunkX, int chunkZ) {
        ImmutableMap<String, Box> map = this.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED);
        int chunkXMin = chunkX << 4;
        int chunkZMin = chunkZ << 4;
        int chunkXMax = chunkXMin + 15;
        int chunkZMax = chunkZMin + 15;
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry entry : map.entrySet()) {
            Box box = (Box)entry.getValue();
            int boxXMin = Math.min(box.getPos1().method_10263(), box.getPos2().method_10263());
            int boxZMin = Math.min(box.getPos1().method_10260(), box.getPos2().method_10260());
            int boxXMax = Math.max(box.getPos1().method_10263(), box.getPos2().method_10263());
            int boxZMax = Math.max(box.getPos1().method_10260(), box.getPos2().method_10260());
            boolean notOverlapping = boxXMin > chunkXMax || boxZMin > chunkZMax || boxXMax < chunkXMin || boxZMax < chunkZMin;
            if (notOverlapping) continue;
            set.add((String)entry.getKey());
        }
        return set;
    }

    public ImmutableMap<String, IntBoundingBox> getBoxesWithinChunk(int chunkX, int chunkZ) {
        ImmutableMap<String, Box> subRegions = this.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED);
        return PositionUtils.getBoxesWithinChunk(chunkX, chunkZ, subRegions);
    }

    @Nullable
    public IntBoundingBox getBoxWithinChunkForRegion(String regionName, int chunkX, int chunkZ) {
        Box box = (Box)this.getSubRegionBoxFor(regionName, SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED).get((Object)regionName);
        return box != null ? PositionUtils.getBoundsWithinChunkForBox(box, chunkX, chunkZ) : null;
    }

    public Set<class_1923> getTouchedChunks() {
        return PositionUtils.getTouchedChunks(this.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED));
    }

    public Set<class_1923> getTouchedChunksForRegion(String regionName) {
        return PositionUtils.getTouchedChunks(this.getSubRegionBoxFor(regionName, SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED));
    }

    private void checkAreSubRegionsModified() {
        Map<String, class_2338> areaPositions = this.schematic.getAreaPositions();
        if (areaPositions.size() != this.relativeSubRegionPlacements.size()) {
            this.regionPlacementsModified = true;
            return;
        }
        for (Map.Entry<String, class_2338> entry : areaPositions.entrySet()) {
            SubRegionPlacement placement = this.relativeSubRegionPlacements.get(entry.getKey());
            if (placement != null && !placement.isRegionPlacementModified(entry.getValue())) continue;
            this.regionPlacementsModified = true;
            return;
        }
        this.regionPlacementsModified = false;
    }

    public void moveSubRegionTo(String regionName, class_2338 newPos) {
        if (this.relativeSubRegionPlacements.containsKey(regionName)) {
            newPos = newPos.method_10059((class_2382)this.origin);
            newPos = PositionUtils.getReverseTransformedBlockPos(newPos, this.mirror, this.rotation);
            this.relativeSubRegionPlacements.get(regionName).setPos(newPos);
            this.onModified();
        }
    }

    public void setSubRegionRotation(String regionName, class_2470 rotation) {
        if (this.relativeSubRegionPlacements.containsKey(regionName)) {
            this.relativeSubRegionPlacements.get(regionName).setRotation(rotation);
            this.onModified();
        }
    }

    public void setSubRegionMirror(String regionName, class_2415 mirror) {
        if (this.relativeSubRegionPlacements.containsKey(regionName)) {
            this.relativeSubRegionPlacements.get(regionName).setMirror(mirror);
            this.onModified();
        }
    }

    public void resetAllSubRegionsToSchematicValues() {
        this.resetAllSubRegionsToSchematicValues(true);
    }

    public void resetAllSubRegionsToSchematicValues(boolean updatePlacementManager) {
        if (updatePlacementManager) {
            // empty if block
        }
        Map<String, class_2338> areaPositions = this.schematic.getAreaPositions();
        this.relativeSubRegionPlacements.clear();
        this.regionPlacementsModified = false;
        for (Map.Entry<String, class_2338> entry : areaPositions.entrySet()) {
            String name = entry.getKey();
            this.relativeSubRegionPlacements.put(name, new SubRegionPlacement(entry.getValue(), name));
        }
        if (updatePlacementManager) {
            this.updateEnclosingBox();
        }
    }

    public void resetSubRegionToSchematicValues(String regionName) {
        class_2338 pos = this.schematic.getSubRegionPosition(regionName);
        SubRegionPlacement placement = this.relativeSubRegionPlacements.get(regionName);
        if (pos != null && placement != null) {
            placement.resetToOriginalValues();
            this.onModified();
        }
    }

    public SchematicPlacement setOrigin(class_2338 origin) {
        if (!this.origin.equals((Object)(origin = PositionUtils.getModifiedPartiallyLockedPosition(this.origin, origin, this.coordinateLockMask)))) {
            this.origin = origin;
            this.updateEnclosingBox();
        }
        return this;
    }

    public SchematicPlacement setRotation(class_2470 rotation) {
        if (this.rotation != rotation) {
            this.rotation = rotation;
            this.updateEnclosingBox();
        }
        return this;
    }

    public SchematicPlacement setMirror(class_2415 mirror) {
        if (this.mirror != mirror) {
            this.mirror = mirror;
            this.updateEnclosingBox();
        }
        return this;
    }

    private void onModified() {
        this.checkAreSubRegionsModified();
        this.updateEnclosingBox();
    }

    public void onRemoved() {
        if (USED_COLORS.isEmpty()) {
            // empty if block
        }
    }

    private Box getEnclosingBox() {
        ImmutableMap<String, Box> boxes = this.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.ANY);
        class_2338 pos1 = null;
        class_2338 pos2 = null;
        for (Box box : boxes.values()) {
            class_2338 tmp = PositionUtils.getMinCorner(box.getPos1(), box.getPos2());
            if (pos1 == null) {
                pos1 = tmp;
            } else if (tmp.method_10263() < pos1.method_10263() || tmp.method_10264() < pos1.method_10264() || tmp.method_10260() < pos1.method_10260()) {
                pos1 = PositionUtils.getMinCorner(tmp, pos1);
            }
            tmp = PositionUtils.getMaxCorner(box.getPos1(), box.getPos2());
            if (pos2 == null) {
                pos2 = tmp;
                continue;
            }
            if (tmp.method_10263() <= pos2.method_10263() && tmp.method_10264() <= pos2.method_10264() && tmp.method_10260() <= pos2.method_10260()) continue;
            pos2 = PositionUtils.getMaxCorner(tmp, pos2);
        }
        if (pos1 != null && pos2 != null) {
            return new Box(pos1, pos2, "Enclosing Box (Servux)");
        }
        return null;
    }

    public void pasteTo(class_3218 serverWorld, ReplaceBehavior replaceBehavior) {
        this.getEnclosingBox().toVanilla().method_54883().forEach(chunkPos -> SchematicPlacingUtils.placeToWorldWithinChunk((class_1937)serverWorld, chunkPos, this, replaceBehavior, false));
    }
}

