/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.config.StructureToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.MiscUtils;
import fi.dy.masa.minihud.util.StructureData;
import fi.dy.masa.minihud.util.StructureType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;

public class OverlayRendererStructures
extends OverlayRendererBase {
    public static final OverlayRendererStructures INSTANCE = new OverlayRendererStructures();
    private boolean wasEmpty = true;

    private OverlayRendererStructures() {
    }

    @Override
    public String getName() {
        return "OverlayRendererStructures";
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        if (!RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            return false;
        }
        for (StructureType type : StructureType.VALUES) {
            if (!type.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        int hysteresis = 16;
        return DataStorage.getInstance().structureRendererNeedsUpdate() || Math.abs(entity.method_23317() - (double)this.lastUpdatePos.method_10263()) > (double)hysteresis || Math.abs(entity.method_23318() - (double)this.lastUpdatePos.method_10264()) > (double)hysteresis || Math.abs(entity.method_23321() - (double)this.lastUpdatePos.method_10260()) > (double)hysteresis;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc) {
        int maxRange = ((Integer)mc.field_1690.method_42503().method_41753() + 4) * 16;
        List<StructureData> data = this.getStructuresToRender(this.lastUpdatePos, maxRange);
        if (!data.isEmpty()) {
            if (this.wasEmpty) {
                this.allocateGlResources();
            }
            RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
            RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
            BUFFER_1 = TESSELLATOR_1.method_60827(renderQuads.getGlMode(), class_290.field_1576);
            BUFFER_2 = TESSELLATOR_2.method_60827(renderLines.getGlMode(), class_290.field_1576);
            this.renderStructureBoxes(data, cameraPos);
            renderQuads.uploadData(BUFFER_1);
            renderLines.uploadData(BUFFER_2);
            this.wasEmpty = false;
        } else {
            this.deleteGlResources();
            this.wasEmpty = true;
        }
    }

    private void renderStructureBoxes(List<StructureData> wrappedData, class_243 cameraPos) {
        for (StructureData data : wrappedData) {
            StructureToggle toggle = data.getStructureType().getToggle();
            Color4f mainColor = toggle.getColorMain().getColor();
            Color4f componentColor = toggle.getColorComponents().getColor();
            this.renderStructure(data, mainColor, componentColor, cameraPos);
        }
    }

    private void renderStructure(StructureData structure, Color4f mainColor, Color4f componentColor, class_243 cameraPos) {
        RenderUtils.drawBox((IntBoundingBox)structure.getBoundingBox(), (class_243)cameraPos, (Color4f)mainColor, (class_287)BUFFER_1, (class_287)BUFFER_2);
        ImmutableList<IntBoundingBox> components = structure.getComponents();
        if (!(components.isEmpty() || components.size() <= 1 && MiscUtils.areBoxesEqual((IntBoundingBox)components.get(0), structure.getBoundingBox()))) {
            for (IntBoundingBox bb : components) {
                RenderUtils.drawBox((IntBoundingBox)bb, (class_243)cameraPos, (Color4f)componentColor, (class_287)BUFFER_1, (class_287)BUFFER_2);
            }
        }
    }

    private List<StructureData> getStructuresToRender(class_2338 playerPos, int maxRange) {
        ArrayListMultimap<StructureType, StructureData> structures = DataStorage.getInstance().getCopyOfStructureDataWithinRange(playerPos, maxRange);
        ArrayList<StructureData> data = new ArrayList<StructureData>();
        for (StructureType type : structures.keySet()) {
            if (!type.isEnabled()) continue;
            data.addAll(structures.get((Object)type));
        }
        return data;
    }
}

